/*------------------------
	+description+
	CCSGlobalVariables.h

	This class is the central hub for variables in an application.
	Its purpose is to provide a common area for run-time variables to be
	set and queried by name.
	
	An accessor off of NSApp has been provided (- globalVariables) which
	returns the instance of this class in an application.  Or, the class
	new method can be used.
	
    Global variables will notify through the default notification center
    when a value of a variable changes.

	Created By:	Craig White
				July 24, 1995


	-description-

	RCS Information
	=============
	$Log: MCGlobalVariables.h,v $
	Revision 1.1  2001/09/23 09:51:24  alykhan
	Integrated Craig's stuff
	
	Revision 1.4  1999/01/07 23:33:46  cwhite
	Added variable will change notification

	Revision 1.3  1998/03/27 15:12:08  cwhite
	Notification on global variables.

	Module sub controllers changing MAIN_CTL var on window main changes

	Revision 1.2  1998/01/09 05:51:54  cwhite
	Small changes for mach

	Revision 1.1  1998/01/09 03:04:00  cwhite
	Porting to OPENSTEP

 * Revision 1.1  1995/11/13  15:59:09  cwhite
 * Added the new classes
 *
 * Revision 1.1  1995/08/29  14:57:38  cwhite
 * Added subprojects to work area
 *
 * Revision 1.1  1995/07/24  22:44:54  cwhite
 * Added GlobalVariables
 *

*/

// Augment this notification with the name of the
// variable you wish to hear about.
// eg. [GlobalVariableChangedNotifyPrefix stringByAppendingString:CURRENT_USER_VAR]
// Should use UNIQUE_STRING() to eliminate OpenStep leak
#define GlobalVariableWillChangeNotifyPrefix	@"globalVariableWillChanged_"
#define GlobalVariableChangedNotifyPrefix		@"globalVariableHasChanged_"



#import <Foundation/Foundation.h>

@interface MCGlobalVariables:NSObject
{
    id	resourceTable;
}

+ (id)defaultGlobalVariables;

- (id)init;
- (void)setValue:aValue ofVariable:(NSString *)aName;
- (id)valueOfVariable:(NSString *)aName;

@end


